//
// $Id: Transform.java,v 1.1 1999/01/13 22:46:07 min Exp min $
//

package transform;

import java.applet.*;
import java.awt.*;
import java.lang.*;
import myutil.*;





public class Transform extends Applet
{
  private static final int NR_TRANSFORMS = 2;  // used to be three
  
  private static final int SCALE = 0;
  private static final int ROTATE = 1;
  private static final int TRANSLATE = 2;
  private static final int NOTHING = 3;
  
  private TransformCanvas my_canvas;
  private Font my_font = new Font("Helvetica", Font.BOLD, 12);
  private Choice[] choices = new Choice[NR_TRANSFORMS];
  private int choice_index[] = new int[NR_TRANSFORMS];
  private TextField[] values = new TextField[NR_TRANSFORMS];
  private Button transform12_button = new Button(" Transform 1 then 2 ");
  private Button transform21_button = new Button(" Transform 2 then 1 ");
  private Button reset_button = new Button(" Reset ");
  private Button store_button = new Button(" Store current transform ");
  private CheckboxGroup my_group = new CheckboxGroup();
  private Checkbox house_checkbox = new Checkbox(" House ");
  private Checkbox face_checkbox = new Checkbox(" Face ");
  private Checkbox display_original = new Checkbox(" Show original (grey) ");
  private Checkbox display_stored = new Checkbox(" Show stored (red) ");

  private Double scale_factor = new Double (1);
  private Double angle = new Double (0);
  private Double dx = new Double (0), dy = new Double(0);
  


  public void init()
  {
    LayoutManager my_layout = new GridBagLayout();
    this.setLayout(my_layout);
    Constrainer c = new Constrainer();
    
    my_canvas = new TransformCanvas();
    c.constrain(this, my_canvas, 0, 0,
      3, 1, GridBagConstraints.BOTH, 
      GridBagConstraints.NORTHWEST, 1.0, 1.0,
      2, 2, 2, 2);
      
    Panel choices_panel = new Panel();
    choices_panel.setLayout(my_layout);
    
    for(int i=0; i < NR_TRANSFORMS; i++)
    {
      choices[i] = new Choice();
      choices[i].setFont(my_font);
      choices[i].addItem(" scale (factor) ");
      choices[i].addItem(" rotate (angle in degrees) ");
      choices[i].addItem(" translate (by (x,y) pixels) ");
      choices[i].addItem(" do nothing ");
      values[i] = new TextField();
      values[i].setFont(my_font);

      c.constrain(choices_panel, choices[i],
		  i, 1, 1, 1, GridBagConstraints.HORIZONTAL,
		  GridBagConstraints.SOUTHWEST, 0.3, 0.0, 2, 2, 2, 2);
      c.constrain(choices_panel, values[i],
		  i, 2, 1, 1, GridBagConstraints.HORIZONTAL,
		  GridBagConstraints.NORTHWEST, 0.3, 0.0, 2, 2, 2, 2);
			       
    }  // for, set up texts and drop boxes
    
    choices[0].select(Transform.ROTATE);
    choice_index[0] = Transform.ROTATE;
    values[0].setText(angle.toString());

    choices[1].select(Transform.TRANSLATE);
    choice_index[1] = Transform.TRANSLATE;
    values[1].setText(dx.toString() + ", " + 
		      dy.toString());
    
    Panel button_panel = new Panel();
    button_panel.setLayout(my_layout);
    button_panel.setFont(my_font);
    c.constrain_button(button_panel, face_checkbox, 0, 0);
    c.constrain_button(button_panel, house_checkbox, 0, 1);
    face_checkbox.setCheckboxGroup(my_group);
    house_checkbox.setCheckboxGroup(my_group);
    my_group.setCurrent(face_checkbox);
    
    c.constrain_button(button_panel, transform12_button, 1, 0);
    c.constrain_button(button_panel, transform21_button, 1, 1);
    c.constrain_button(button_panel, reset_button, 2, 0);
    c.constrain_button(button_panel, store_button, 2, 1);
    c.constrain_button(button_panel, display_original, 3, 0);
    c.constrain_button(button_panel, display_stored, 3, 1);
    
    c.constrain(this, choices_panel, 0, 3,
      3, 1, GridBagConstraints.HORIZONTAL,
      GridBagConstraints.NORTHWEST, 1.0, 0.0, 5, 0, 5, 0);
    c.constrain(this, button_panel, 0, 4,
      3, 1, GridBagConstraints.HORIZONTAL,
      GridBagConstraints.NORTHWEST, 1.0, 0.0, 5, 0, 5, 0);
    
     this.show();
  }  // init



  public String getAppletInfo()
  {
    return "2D Transforms v1.1 by Patrick Min, min@cs.princeton.edu\n$Id: Transform.java,v 1.1 1999/01/13 22:46:07 min Exp min $\n";
  }  // getAppletInfo
  
  

  public boolean action(Event e, Object arg)
  {
    if ((e.target == transform12_button) || (e.target == transform21_button)) {
      int indices[] = new int[2];
      if (e.target == transform12_button) {
	indices[0] = 0;
	indices[1] = 1;
      }
      else {
	indices[0] = 1;
	indices[1] = 0;
      }
      
      // get the indices of choices
      // call appropriate smooth transform functions
      for(int i=0; i < NR_TRANSFORMS; i++)
      {
	int index = indices[i];
        int transform_type = choices[index].getSelectedIndex();

	choices[index].setForeground(Color.red);
        switch (transform_type)
        {
          case Transform.SCALE:
	    try {
	      scale_factor = Double.valueOf(values[index].getText());
	    }
	    catch (NumberFormatException exc) {
	      System.out.println("Number format error");
	      scale_factor = new Double(1.0);
	      values[index].setText("1.0");
	    }
	    my_canvas.smooth_scale(scale_factor.doubleValue());
            break;
          case Transform.ROTATE: 
	    try {
	      angle = Double.valueOf(values[index].getText());
	    }
	    catch (NumberFormatException exc) {
	      System.out.println("Number format error");
	      angle = new Double(0.0);
	      values[index].setText("0");
	    }
	    double angle_d = angle.doubleValue() / 180 * Math.PI;
	    //
	    // note: -angle_d instead of angle_d because Java positive y
	    // is pointing downwards, and ours is pointing up
	    //
	    my_canvas.smooth_rotate(-angle_d);
            break;
          case Transform.TRANSLATE: 
	    try {
	      String value = values[index].getText();
	      int separator_index = value.indexOf(',');
	      if (separator_index <= 0) separator_index = value.indexOf(' ');
	      if (separator_index > 0) {
		String left = value.substring(0, separator_index);
		String right = value.substring(separator_index + 1);
		dx = Double.valueOf(left);
		dy = Double.valueOf(right);
	      }
	      else {
		throw new NumberFormatException();
	      }
	    }
	    catch (NumberFormatException exc) {
	      System.out.println("Number format error");
	      dx = new Double (0);
	      dy = new Double (0);
	      values[index].setText("0, 0");
	    }
	    my_canvas.smooth_translate(dx.doubleValue(), dy.doubleValue());
            break;
          default:
        }  // switch
	choices[index].setForeground(Color.black);
      }  // for
      return true;
    }
    else if (e.target == reset_button) {
      my_canvas.reset_transform();
    }
    else if (e.target == store_button) {
      my_canvas.store_current_matrix();
    }
    else if ((e.target == choices[0]) || (e.target == choices[1])) {
      //	     (e.target == choices[2])) {
      int index;
      if (e.target == choices[0]) index = 0;
      else index = 1;
      //      else if (e.target == choices[1]) index = 1;
      //      else index = 2;
      int chosen = choices[index].getSelectedIndex();
      if (chosen != choice_index[index]) {  // if selection has changed
	choice_index[index] = chosen;
	switch (chosen) {  // set default value depending on transformation
	case Transform.SCALE: values[index].setText("1.0");
	  break;
	case Transform.ROTATE: values[index].setText("0");
	  break;
	case Transform.TRANSLATE: values[index].setText("0, 0");
	  break;
	case Transform.NOTHING: values[index].setText("n/a");
	  break;
	}  // switch
      }  // else if, transformation list clicked
    }
    else if (e.target == face_checkbox) {
      my_canvas.set_face();
      my_canvas.paint();
    }
    else if (e.target == house_checkbox) {
      my_canvas.set_house();
      my_canvas.paint();
    }
    else if (e.target == display_original) {
      my_canvas.toggle_display_original();
      my_canvas.paint();
    }
    else if (e.target == display_stored) {
      my_canvas.toggle_display_previous();
      my_canvas.paint();
    }
    return false;
  }  // action
  
  
}  // Transform applet
