//
// $Id: GraphicsObject.java,v 1.1 1999/01/13 22:46:07 min Exp min $
//
// Older version of "GraphicsObject", different from the one in ../graphutil
//

package transform;

import java.awt.*;
import java.lang.*;
import vectors.*;



public class GraphicsObject 
{
  private static final int MAX_POLYGONS = 20;
  private Color colours[] = new Color[MAX_POLYGONS];
  private Color current_colour = new Color(0, 0, 0);
  private Polygon polygons[] = new Polygon[MAX_POLYGONS];
  private int nr_polygons;
  
  private int state;
  public static final int DISPLAY_GREY = 0;
  public static final int DISPLAY_COLOUR = 1;
  private Color grey_colour = Color.red;
  
  
  
  public GraphicsObject()
  {
    state = DISPLAY_COLOUR;
    nr_polygons = 0;
    current_colour = Color.black;
  }  // constructor
  
  
  
  public void add_polygon(Polygon p)
  {
    polygons[nr_polygons] = new Polygon();
    polygons[nr_polygons] = p;
    colours[nr_polygons] =
      new Color(current_colour.getRed(),
                current_colour.getGreen(),
                current_colour.getBlue());
    nr_polygons++;
  }  // add_polygon
  
  
  
  public void set_state(int new_state)
  {
    state = new_state;
  }  // set_state
  
  
  
  public void set_colour(Color new_colour)
  {
    current_colour = new_colour;
  }

  public void set_grey_colour(Color new_colour)
  {
    grey_colour = new_colour;
  }
  
  
  
  public void draw(Graphics g, Matrix transform_matrix)
  {
    for(int i=0; i<nr_polygons; i++)
    {
      Polygon temp = new Polygon();
      Vector temp_vec = new Vector();
      int first_x = 0;
      int first_y = 0;

      g.setColor(Color.red);
      
      for(int j=0; j<polygons[i].npoints; j++)
      {
        temp_vec = 
          new Vector((double) polygons[i].xpoints[j], 
                     (double) polygons[i].ypoints[j]);
                     
          temp_vec = transform_matrix.vec_postmultiply(temp_vec);
          
          temp.addPoint((int) temp_vec.get_x(), (int) temp_vec.get_y());
          if (j==0) {
            first_x = (int) temp_vec.get_x();
            first_y = (int) temp_vec.get_y();
          }
      }
      if (state == DISPLAY_GREY)
	g.setColor(grey_colour);
      else
        g.setColor(colours[i]);
        
      g.drawPolygon(temp);
      // why do I need an extra drawLine?
      g.drawLine((int) temp_vec.get_x(), (int) temp_vec.get_y(),
        first_x, first_y);
    }  // for, all polygons
  }  // draw
  
}  // class GraphicsObject


  
