//
// $Id: ThreeDCanvas.java,v 1.2 1997/03/03 22:14:40 min Exp min $
//

package threed;

import java.awt.*;
import java.lang.*;

import graphutil.*;
import vectors.*;





public class ThreeDCanvas extends Canvas
{
  private static final boolean DEBUG = false;

  private BasicRenderer my_renderer;
  private Scene my_scene;
  
  private Image offscreen;
  private int image_width;
  private int image_height;

  private boolean repaint = true;  // true if picture needs to be re-rendered
  private boolean always_repaint = true;  // always re-render, no matter what



  public ThreeDCanvas()
  {
  }  // constructor
  
  

  public void invalidate()
  {
    repaint = true;
  }  // invalidate



  public void set_always_repaint(boolean new_value)
  {
    always_repaint = new_value;
  }  // set_always_repaint



  public Dimension preferredSize()
  {
    return new Dimension(400, 300);
  }  // preferredSize



  public Dimension minimumSize()
  {
    return new Dimension(200, 150);
  }  // minimumSize



  public void set_scene(Scene new_scene)
  {
    if (ThreeDCanvas.DEBUG) {
      System.out.println("scene for canvas has been set");
    }
    my_scene = new_scene;
  }  // set_scene
  


  public void set_renderer(BasicRenderer new_renderer)
  {
    if (ThreeDCanvas.DEBUG) {
      System.out.println("renderer for canvas has been set");
    }
    my_renderer = new_renderer;
  }  // set_renderer



  public void set_renderer(Renderer new_renderer)
  {
    my_renderer = new_renderer;
  }



  public void paint()
  {
    Dimension d = this.size();
    if ((offscreen == null) || (d.width != image_width) ||
      (d.height != image_height))
    {
      if ((d.width < 1) || (d.height < 1)) return;
      if (ThreeDCanvas.DEBUG) {
	System.out.println("First time paint, initializing offscreen");
      }
      offscreen = this.createImage(d.width, d.height);
      image_width = d.width;
      image_height = d.height;
      // call Renderer for change in viewport transform
      my_renderer.compute_viewport_matrix(image_width, image_height);
      repaint = true;
    }  // if, window size has changed

    if (always_repaint || repaint) {
      if (ThreeDCanvas.DEBUG) {
	System.out.println("ThreeDCanvas: about to call render");
      }
      Graphics off_g = offscreen.getGraphics();
      clear(off_g);    
      my_renderer.render(off_g, my_scene);
      repaint = false;
    }
    Graphics my_g = this.getGraphics();
    my_g.drawImage(offscreen, 0, 0, this);
  }  // paint
  


  public void paint(Graphics g)
  {
    paint();
  }  // official paint



  public Image get_image()
  {
    return offscreen;
  }  // get_image



  public int get_width()
  {
    return image_width;
  }  // get_width



  public int get_height()
  {
    return image_height;
  }  // get_height



  void clear(Graphics g)
  {
    g.setColor(Color.black);
    g.fillRect(0, 0, image_width, image_height);
  }  // clear
  
  
          
  
}  // ThreeDCanvas class

