//
// $Id: Layout.java,v 1.2 1998/07/30 08:40:13 min Exp $
//
// The "better" version of the Constrainer class, with static methods.
// 

package myutil;

import java.awt.*;





public class Layout
{

  
  public static void constrain(Container container, Component component,
    int grid_x, int grid_y, int grid_width, int grid_height,
    int fill, int anchor, double weight_x, double weight_y,
    int top, int left, int bottom, int right)
  {
    constrain(container, component, grid_x, grid_y, grid_width, grid_height,
	      fill, anchor, weight_x, weight_y, top, left, bottom, right,
	      0, 0);
  }  // constrain


  
  public static void constrain(Container container, Component component,
    int grid_x, int grid_y, int grid_width, int grid_height,
    int fill, int anchor, double weight_x, double weight_y,
    int top, int left, int bottom, int right, int ipadx, int ipady)
  {
    GridBagConstraints gc = new GridBagConstraints();

    gc.gridx = grid_x;
    gc.gridy = grid_y;
    gc.gridwidth = grid_width;
    gc.gridheight = grid_height;
    gc.fill = fill;
    gc.anchor = anchor;
    gc.weightx = weight_x;
    gc.weighty = weight_y;
    gc.ipadx = ipadx;
    gc.ipady = ipady;
    if (top + bottom + left + right > 0)
      gc.insets = new Insets(top, left, bottom, right);
      
    ((GridBagLayout) container.getLayout()).setConstraints(component, gc);
    container.add(component);
  }  // constrain 
  


  public static void constrain_button(Container container, 
    Component component, int grid_x, int grid_y)
  {
    constrain(container, component, grid_x, grid_y, 1, 1,
      GridBagConstraints.NONE, GridBagConstraints.CENTER,
      0.2, 0.0, 5, 2, 5, 2, 2, 2);
  }  // constrain_button
      
    

  public static void constrain_field(Container container, 
    Component component, int grid_x, int grid_y)
  {
    constrain(container, component, grid_x, grid_y, 1, 1,
      GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER,
      1.0, 0.2, 1, 1, 1, 1);
  }  // constrain_field
      
    
}  // Layout class
