//
// $Id: Datafile.java,v 1.1 1998/07/12 13:34:47 min Exp min $
//
// Implements a tokenized file.  Couldn't get java.io.StreamTokenizer to
// work, that's why.
//

package myutil;

import java.lang.*;
import java.io.*;

import vectors.*;



public class Datafile
{
  private DataInputStream my_data;
  private FileInputStream my_file;
  private static final int MAX_KEYWORD_LENGTH = 32;



  public Datafile(String name)
  {
    try {
      my_file = new FileInputStream(name);
    }
    catch (FileNotFoundException e) {
      System.out.println(e.getMessage());
    }
    my_data = new DataInputStream(my_file);
  }  // constructor



  public Datafile(InputStream in_stream)
  {
    my_data = new DataInputStream(in_stream);
  }  // constructor with InputStream



  public void skip_line()
  {
    try {
      my_data.readLine();
    }
    catch (IOException e) {
      System.out.println(e.getMessage());
    }
  }  // skip_line



  public boolean is_token_char(char k)
  {
    return (Character.isLowerCase(k) || Character.isUpperCase(k) ||
	    Character.isDigit(k) || (k == '.') || (k == '_') || (k == '-'));
  }  // is_token_char



  public String get_token()
  {
    StringBuffer token = new StringBuffer(MAX_KEYWORD_LENGTH);

    char k;
    try {
      do {
	k = (char) my_data.readUnsignedByte();
	if (k == '#') skip_line();
      } while (!is_token_char(k));

      token.append(k);
      do {
	k = (char) my_data.readUnsignedByte();
	if (is_token_char(k))
	  token.append(k);
	else
	  if (k == '#') skip_line();
      } while (is_token_char(k));
    }  // try
    
    catch (EOFException e) {}
    catch (IOException e) {
      System.out.println(e.getMessage());
    }

    return token.toString().toLowerCase();
  }  // get_token



  public boolean accept(String wanted)
  {
    String token = get_token();
    wanted.toLowerCase();
    if (token.equals(wanted)) return true;
    else {
      System.out.println("Parse error: expected: " + 
			 wanted + ", read: " + token);
      return false;
    }
  }  // accept



  public int get_int()
  {
    int number = 0;
    String token = new String("");

    try {
      token = get_token();
      number = Integer.parseInt(token);
    }
    catch (NumberFormatException e) {
      System.out.println("Parse error: number expected, read: "
			 + token);
    }
    return number;
  }  // get_int



  public double get_double()
  {
    double number = 0;
    String token = new String("");

    try {
      token = get_token();
      number = Double.valueOf(token).doubleValue();
    }
    catch (NumberFormatException e) {
      System.out.println("Parse error: number expected, read: "
			 + token);
    }
    return number;
  }  // get_double



  public Vector get_vector()
  {
    double temp[] = new double[3];
    Vector result = new Vector();

    try {
      for(int i=0; i<3; i++) {
	temp[i] = my_data.readDouble();
      }
    }  // try
    catch (EOFException e) {}
    catch (IOException e) {
      System.out.println(e.getMessage());
    }
    result.set(temp[0], temp[1], temp[2]);
    return result;
  }  // get_vector


}  // Datafile class


