//
// $Id: Scenefile.java,v 1.1 1998/08/03 16:00:22 min Exp min $
//

package graphutil;

import java.lang.*;
import java.awt.*;
import java.io.*;

import myutil.*;
import graphutil.*;
import vectors.*;





public class Scenefile extends Datafile
{
  private String filespec;

  private int max_vertices;
  private Vector vertices[];
  private int nr_vertices = 0;



  public Scenefile(String name)
  {
    super(name);
    filespec = new String(name);
  }  // constructor



  public Scenefile(InputStream in_stream)
  {
    super(in_stream);
  }  // constructor with InputStream



  public void parse(Scene s)
  {
    boolean done = false;

    if (!accept("scene")) return;
    
    while (!done) {
      String token = get_token();

      if (token.equals("max_vertices")) {
	max_vertices = get_int();
	vertices = new Vector[max_vertices];
      }
      else if (token.equals("vertex")) {
	vertices[nr_vertices] = 
	  new Vector(get_double(), get_double(), get_double());
	nr_vertices++;
      }
      else if (token.equals("object"))
	parse_object(s);
      else if (token.equals("end_scene"))
	done = true;
      else {
	System.out.println("Parse error: unknown keyword " + token);
	done = true;
      }
    }  // while
  }  // parse



  private void parse_object(Scene s)
  {
    GraphicsObject obj = new GraphicsObject();
    boolean done = false;

    while (!done) {
      String token = get_token();
      if (token.equals("polygon"))
	parse_polygon(obj);
      else if (token.equals("colour")) {
	Color colour = new Color(get_int(), get_int(), get_int());
	obj.set_Color(colour);
      }
      else if (token.equals("sphere")) {
	obj.set_sphere(new Vector(get_double(), get_double(), get_double()),
		       get_double());
      }
      else if (token.equals("end_object"))
	done = true;
      else {
	System.out.println("Parse error: unknown keyword " + token);
	done = true;
      }
    }  // while
    s.add_object(obj);
  }  // parse_object



  private void parse_polygon(GraphicsObject obj)
  {
    MyPolygon p = new MyPolygon();
    boolean done = false;
    String token = new String("");

    try {
      while (!done) {
	token = get_token();
	if (token.equals("end"))
	  done = true;
	else {
	  int index;
	  index = Integer.parseInt(token);
	  p.addPoint(vertices[index]);
	}
      }  // while
      obj.add_polygon(p);
    }
    catch (NumberFormatException e) {
      System.out.println("Parse error: vertex index expected, read: "
			 + token);
      done = true;
    }  // catch
  }  // parse_polygon


}  // Scenefile class


	
