//
// $Id: PictureFrame.java,v 1.1 1998/08/03 16:00:22 min Exp min $
//

package graphutil;

import java.applet.*;
import java.awt.*;
import java.lang.*;





public class PictureFrame extends Applet 
{
  private Image my_image;

  private Frame my_frame;
  private Button close_button = new Button("Close");
  private TextField status_line = new TextField();
  private Font my_font = new Font("Helvetica", Font.BOLD, 12);


  public PictureFrame(Image new_image, int width, int height, String name)
  {
    my_image = createImage(new_image.getSource());

    my_frame = new Frame(name);  
    my_frame.add("Center", this);
    my_frame.add("South", status_line);
    close_button.setFont(my_font);
    status_line.setFont(new Font("Courier", Font.BOLD, 12));
    status_line.setEditable(false);

    this.add("South", close_button);
    my_frame.resize(width, height + 64);
    my_frame.show();
  }  // constructor



  public void set_status_line(String new_text)
  {
    status_line.setText(new_text);
  }  // set_status_line



  public void paint(Graphics g)
  {
    g.drawImage(my_image, 0, 0, my_frame);
  }  // paint



  public boolean action(Event e, Object arg)
  {
    if (e.target == close_button) {
      my_frame.hide();
      my_frame.dispose();
      my_image = null;
      destroy();
      stop();
      return true;
    }
    return false;
  }  // action



}  // PictureFrame class

