//
// $Id: MyPolygon.java,v 1.1 1998/08/03 16:00:22 min Exp min $
//

package graphutil;

import java.lang.*;
import java.awt.*;
import vectors.*;



public class MyPolygon
{
  private static final int MAX_POINTS = 20;
  private int nr_points;
  private Vector points[] = new Vector[MAX_POINTS];
  private Vector normal;
  private boolean closed = true;
  
  
  
  public MyPolygon()
  {
    nr_points = 0;
  }  // constructor
  
  

  public void set_closed(boolean new_value)
  {
    closed = new_value;
  }  // set_closed



  public boolean get_closed()
  {
    return closed;
  }  // get_closed


  
  public void addPoint(Vector P)
  {
    points[nr_points] = new Vector(P);
    nr_points++;
    if (nr_points == 3) {  // enough points to compute normal
      Vector A = points[1].subtract(points[0]);
      Vector B = points[2].subtract(points[1]);
      normal = A.cross_product(B);
      normal.normalize();
    }
  }  // addPoint
  
  
  
  public void addPoint(double x, double y)
  {
    Vector P = new Vector(x, y);
    addPoint(P);
  }  // addPoint
  
  
  
  public void addPoint(double x, double y, double z)
  {
    Vector P = new Vector(x, y, z);
    addPoint(P);
  }  // addPoint
  


  public Vector get_point(int index)
  {
    return points[index];
  }  // getPoint
  
  

  public Vector get_normal()
  {
    return normal;
  }  // get_normal



  public int get_nr_points()
  {
    return nr_points;
  }  // get_nr_points
  
  
}  // MyPolygon class

