//
// $Id: Light.java,v 1.1 1998/08/03 16:00:22 min Exp min $
//

package graphutil;

import java.applet.*;
import java.awt.*;
import java.lang.*;

import vectors.*;



public class Light
{
  private Vector position = new Vector();
  private Vector colour = new Vector();



  public Light()
  {
    colour.set(1, 1, 1);
  }  // constructor



  public Light(Vector new_pos, Vector new_col)
  {
    position = new_pos;
    colour = new_col;
  }  // constructor



  public Vector get_position()
  {
    return position;
  }  // get_position



  public Vector get_colour()
  {
    return colour;
  }  // get_colour



  public Vector diffuse_contribution(Vector pos, Vector normal,
				     Vector col, double k_d,
				     boolean attenuation)
  {
    Vector to_light = position.subtract(pos);
    double dist = to_light.length();
    to_light.normalize();
    normal.normalize();
    Vector temp = colour.multiplied_by(to_light.dot_product(normal));
    if (attenuation) temp = temp.divided_by(dist * dist);
    temp = temp.multiplied_by(k_d);
    temp.clamp(0, 1);
    Vector result = new Vector(temp.get_x() * col.get_x(),
			       temp.get_y() * col.get_y(),
			       temp.get_z() * col.get_z());
    return result;
  }  // diffuse_contribution



  public Vector specular_contribution(Vector pos, Vector normal,
				      Vector viewer_pos, Vector col,
				      double k_s, double n_s,
				      boolean attenuation)
  {
    Vector result = new Vector(0, 0, 0);
    Vector L = position.subtract(pos);
    double dist = L.length();
    L.normalize();
    normal.normalize();
    // if angle between normal and to-light vector larger than 90 degrees, no influence from this light
    double ln_dot = L.dot_product(normal);
    if (ln_dot < 0) return result;  
    
    Vector R = normal.multiplied_by(2 * normal.dot_product(L)).subtract(L);

    Vector to_viewer = viewer_pos.subtract(pos);
    to_viewer.normalize();

    Vector temp = 
      colour.multiplied_by(k_s * Math.pow(to_viewer.dot_product(R), n_s));
    if (attenuation) temp = temp.divided_by(dist * dist);
    temp.clamp(0, 1);
    result = new Vector(temp.get_x() * col.get_x(),
			temp.get_y() * col.get_y(),
			temp.get_z() * col.get_z());
    return result;
  }  // specular_contribution


}  // Light class

