//
// $Id: GraphicsObject.java,v 1.1 1998/08/03 16:00:22 min Exp min $
//
// Pretty ugly class to hold either a list of polygons or a sphere...
//

package graphutil;

import java.awt.*;
import java.lang.*;
import vectors.*;



public class GraphicsObject 
{
  private static final int MAX_POLYGONS = 100;
  private Vector colours[] = new Vector[MAX_POLYGONS];
  private Vector current_colour;
  private MyPolygon polygons[] = new MyPolygon[MAX_POLYGONS];
  private int nr_polygons = 0;
  
  private int state;
  public static final int DISPLAY_GREY = 0;
  public static final int DISPLAY_COLOUR = 1;
  public static final int DONT_DISPLAY = 2;
  
  private Matrix transform;
  private boolean has_a_matrix = false;
  
  private Vector hotspot = null;
  
  private boolean is_a_sphere = false;
  private Vector center;
  private double radius;

  // "renderer" state variable
  private boolean rendered = false;




  
  public GraphicsObject()
  {
    state = DISPLAY_COLOUR;
    current_colour = new Vector(1, 1, 1);
  }  // constructor
  
  

  public void set_matrix(Matrix new_matrix)
  {
    transform = new_matrix;
    has_a_matrix = true;
  }  // set_matrix



  public Matrix get_matrix()
  {
    return transform;
  }  // get_matrix

  

  public boolean has_matrix()
  {
    return has_a_matrix;
  }  // has_matrix



  public boolean get_rendered()
  {
    return rendered;
  }  // get_rendered



  public void set_rendered(boolean new_value)
  {
    rendered = new_value;
  }  // set_rendered



  public void set_sphere(Vector new_center, double new_radius)
  {
    is_a_sphere = true;
    radius = new_radius;
    Matrix trans = new Matrix();
    center = new_center;
    colours[0] = new Vector(current_colour);
  }  // set_sphere


  public boolean is_sphere()
  {
    return is_a_sphere;
  }  // is_sphere



  public Vector get_center()
  {
    return center;
  }  // get_center



  public void set_center(Vector new_center)
  {
    center = new_center;
  }  // set_center



  public double get_radius()
  {
    return radius;
  }  // get_radius



  public boolean intersect(Vector from, Vector to, Vector intersection)
  {
    double x1 = from.get_x();
    double x2 = to.get_x();
    double y1 = from.get_y();
    double y2 = to.get_y();
    double z1 = from.get_z();
    double z2 = to.get_z();

    double l = center.get_x();
    double m = center.get_y();
    double n = center.get_z();

    double i = x2-x1;
    double j = y2-y1;
    double k = z2-z1;

    double a = i*i + j*j + k*k;
    double b = 2*i*(x1 - l) + 2*j*(y1 - m) + 2*k*(z1 - n);
    double c = l*l + m*m + n*n + x1*x1 + y1*y1 + z1*z1 + 
      2*(-l*x1 - m*y1 - n*z1) - radius*radius;

    double det = b*b-4*a*c;

    if (det <= 0) return false;

    double t1 = (-b + Math.sqrt(det))/(2*a);
    double t2 = (-b - Math.sqrt(det))/(2*a);
    
    if (t1 < t2)
      intersection.set(x1 + i*t1, y1 + j*t1, z1 + k*t1);
    else
      intersection.set(x1 + i*t2, y1 + j*t2, z1 + k*t2);

    return true;
  }  // intersect



  public void set_hotspot(Vector new_hotspot)
  {
    hotspot = new_hotspot;
  }  // set_hotspot



  public Vector get_hotspot()
  {
    return hotspot;
  }  // get_hotspot



  public void add_polygon(MyPolygon p)
  {
    polygons[nr_polygons] = p;
    colours[nr_polygons] = new Vector(current_colour);
    nr_polygons++;
  }  // add_polygon
  
  

  public int get_nr_polygons()
  {
    return nr_polygons;
  }  // get_nr_polygons



  public MyPolygon get_polygon(int index)
  {
    return polygons[index];
  }  // get_polygon



  public void set_state(int new_state)
  {
    state = new_state;
  }  // set_state
  
  

  public int get_state()
  {
    return state;
  }  // get_state



  public void set_colour(Vector new_colour)
  {
    current_colour = new_colour;
  }  // set_colour
  
  

  public void set_Color(Color new_colour)
  {
    current_colour = new Vector((double) new_colour.getRed() / 255.0D,
				(double) new_colour.getGreen() / 255.0D,
				(double) new_colour.getBlue() / 255.0D);
  }  // set_Color



  public Vector get_colour(int index)
  {
    return colours[index];
  }  // get_colour

  

  public Color get_Color(int index)
  {
    return new Color((float) colours[index].get_x(),
		     (float) colours[index].get_y(),
		     (float) colours[index].get_z());
  }  // get_Color


}  // class GraphicsObject


