//
// $Id: BezierPoint.java,v 1.4 1997/03/03 20:28:02 min Exp min $
//

package bezier;

import java.awt.*;
import vectors.*;





public class BezierPoint
{
  public static final int SET = 0;
  public static final int MOVING = 1;
  public static final int CLOSEST = 2;
  private int state = 0;
  
  private static final int MYWIDTH = 10;
  private static final int MYHEIGHT = 10;
  private int x;
  private int y;
  
  
  public BezierPoint()
  {
    moveto(0, 0);
  }  // default constructor
  
  
  
  public BezierPoint(int x, int y)
  {
    moveto(x, y);
  }  // constructor
  
  
  
  public Vector make_vector()
  {
    Vector result =
      new Vector((double) x, (double) y);
    return result;
  }  // make_vector
  
  
  
  public void moveto(int x, int y)
  {
    this.x = x;
    this.y = y;
  }  // moveto
  
  
  
  public void setstate(int new_state)
  {
    state = new_state;
  }  // setstate
  
  
  
  public int get_x()
  {
    return x;
  }
  
  
  
  public int get_y()
  {
    return y;
  }
  
  
  
  public void draw(Graphics g)
  {
    int cx = x - MYWIDTH/2;
    int cy = y - MYWIDTH/2;
    switch (state)
    {
      case SET:
        g.setColor(Color.blue);
        g.fillOval(cx, cy, MYWIDTH, MYHEIGHT);
      break;
    case MOVING:
      g.setColor(Color.white);        
        g.drawOval(cx + MYWIDTH/4, cy+MYHEIGHT/4, 
               MYWIDTH/2, MYHEIGHT/2);
        break;
      case CLOSEST:
        g.setColor(Color.white);
        g.drawLine(cx, cy, cx+MYWIDTH, cy+MYHEIGHT);
        g.drawLine(cx, cy+MYHEIGHT, cx+MYWIDTH, cy);
        break;
      default:
        System.out.println("BezierPoint draw: illegal state");
    }
  }  // draw
  
  

  public void scale(double x_scale, double y_scale)
  {
    x = (int)(x_scale * (double) x);
    y = (int)(y_scale * (double) y);
  }  // scale
  
    
}  // BezierPoint class

