//
// $Id: Bezier.java,v 1.5 1997/03/03 20:28:02 min Exp min $
//

package bezier;

import java.awt.*;
import java.applet.*;
import java.lang.*;
import java.util.*;
import myutil.*;





public class Bezier extends Applet
{
  private Checkbox display_hull;
  private TextField user_info = new TextField
    ("Left click = add point, Middle click = toggle points display, Right click = delete point, Mouse drag = move point");
  private Checkbox display_hint;
  private Button clear_button = new Button("Clear");

  private Font my_font = new Font("Helvetica", Font.BOLD, 12);

  private BezierCanvas my_canvas;

  private TextArea info_text;
  
  private int width;
  private int height;
  
  
  
  public void init()
  {
    display_hull = new Checkbox("Display convex hull");
    display_hull.setFont(my_font);

    user_info.setFont(my_font);
    user_info.setEditable(false);

    display_hint = new Checkbox("Display C1 continuity hint");
    display_hint.setFont(my_font);

    clear_button.setFont(my_font);

    LayoutManager my_layout = new GridBagLayout();
    this.setLayout(my_layout);
    Constrainer my_constraints = new Constrainer();
    
    Panel button_panel = new Panel();
    button_panel.setLayout(my_layout);
    
    // top line, text & 2 checkboxes
    my_constraints.constrain(button_panel, user_info,
			     0, 0, 3, 1, GridBagConstraints.NONE,
			     GridBagConstraints.CENTER, 0.3, 0, 0, 0, 0, 0);
    my_constraints.constrain(button_panel, display_hull,
			     0, 1, 1, 1, GridBagConstraints.NONE, 
			     GridBagConstraints.CENTER, 0.3, 0, 0, 0, 0, 0);
    my_constraints.constrain(button_panel, display_hint,
			     1, 1, 1, 1, GridBagConstraints.NONE, 
			     GridBagConstraints.CENTER, 0.3, 0, 0, 0, 0, 0);
    my_constraints.constrain(button_panel, clear_button,
			     2, 1, 1, 1, GridBagConstraints.NONE, 
			     GridBagConstraints.CENTER, 0.3, 0, 0, 0, 0, 0);

    my_constraints.constrain(this, button_panel, 0, 0,
			     4, 2, GridBagConstraints.HORIZONTAL,
			     GridBagConstraints.NORTHWEST, 
			     1.0, 0.0, 5, 0, 5, 0);
    
    my_canvas = new BezierCanvas();
    my_constraints.constrain(this, my_canvas, 0, 2,
 			     3, 3, GridBagConstraints.BOTH,
 			     GridBagConstraints.NORTHWEST, 
 			     0.75, 1.0, 0, 0, 0, 0);

    Panel text_panel = new Panel();
    text_panel.setLayout(my_layout);
    
    info_text = new TextArea("Point coordinates will be shown here", 35, 16, TextArea.SCROLLBARS_NONE);
    info_text.setFont(my_font);
    info_text.setEditable(false);
    text_panel.add(info_text);
    
    my_constraints.constrain(text_panel, info_text,
			     0, 0, 1, 1, GridBagConstraints.BOTH,
			     GridBagConstraints.CENTER, 1.0, 0, 0, 0, 0, 0);
    my_constraints.constrain(this, text_panel, 3, 2,
			     1, 3, GridBagConstraints.VERTICAL,
			     GridBagConstraints.NORTHWEST, 
			     1.0, 1.0, 0, 0, 0, 0);

    this.show();
    
  }  // init
  
  

  public String getAppletInfo()
  {
    return "Bezier curves v1.1 by Patrick Min, min@cs.princeton.edu\n$Id: Bezier.java,v 1.5 1997/03/03 20:28:02 min Exp min $";
  }  // getAppletInfo



  public void paint(Graphics g)
  {
    my_canvas.paint(g);
  }  // paint



  public void update_points_list()
  {
    int nr_points = my_canvas.get_nr_points();
    
    StringBuffer coordinates = new StringBuffer();
    
    for(int i=0; i < nr_points; i++) {
      BezierPoint point = my_canvas.get_point(i);

      int px = point.get_x();
      int py = point.get_y();

      coordinates.append(i + ": (" + px + ", " + py + ")\n");
      
    }  // for

    info_text.setText(coordinates.toString());

  }  // update_points_list


  
  public boolean mouseDown(Event e, int x, int y)
  {
    update_points_list();
    return true;
    
  }  // mouseDown


  
  public boolean action(Event e, Object arg)
  {
    if (e.target == display_hull)
    {
      my_canvas.toggle_hull();
      my_canvas.paint();
      return true;
    }
    else if (e.target == display_hint) {
      my_canvas.toggle_hint();
      my_canvas.paint();
    }
    else if (e.target == clear_button) {
      my_canvas.clear();
      my_canvas.paint();
    }
    return false;
  }  // action
  
  
}  // Bezier applet
